require("json")

local function new_hint(less)
	local self = {}
	self.less = less
	
	self.next = function(self)
		return self.less:latest_exem()
	end
	
	self.wrong = function(self)
		local loc  = self.less:locate()
    	local diff = self.less:diff(loc)	
		local len  = ucs2.len(diff)
		--if len > 0 then
    	--	return self.less:latest_input()
    	--end
    	--return L""
		return diff
	end	
	
	return self
end

local function new_stat(less)
	local self = {}
	self.less        = less
	self.start       = 0
	self.pause_start = 0
	self.pause_total = 0
	self.time_offset = 0
	
	self.init_time = function (self, timeoffset)
		self.time_offset = timeoffset
	end
	
	self.tick = function (self)
		if self.start == 0 then
		  self.start = os.clock()
		end
	end

	self.pause = function (self)
		self.pause_start = os.clock()
	end

	self.resume = function (self)
		self.pause_total = self.pause_total + os.clock() - self.pause_start
	end
	
	self.elapse = function (self)
		if self.start == 0 then
			return 0
		end
		return os.clock() - self.start + 1 - self.pause_total + self.time_offset
	end

	self.accu = function (self)
		return self.less:accu()
	end

	self.speed = function (self)
		if self:elapse() == 0 then
			return 0
		end
		return self.less:input_maxcp() / self:elapse()
	end

	self.word = function (self)
		return self.less:input_maxcp()
	end
	
	self.progress = function (self)
		return self.less:progress()
	end

	return self
end

local function new_page(less, span_count)
	
	local self = {}
	
	self.less 	    = less
	self.span_count = span_count	
	self.stat       = new_stat(less)
	self.hint       = new_hint(less)

	local function locate_start_span(less)
		local loc = less:locate()
		return math.floor((loc-1) / self.span_count) * self.span_count
	end
	
	self.se = function (self, index)
		local start_span = locate_start_span(self.less)
		return self.less:se(start_span + index)
	end
	
	self.se2 = function (self, index)
		local start_span = locate_start_span(self.less)
		return self.less:se2(start_span + index)
	end
	
	self.se3 = function (self, index)
		local start_span = locate_start_span(self.less)
		return self.less:se3(start_span + index)
	end
	
	self.si = function (self, index)
		local start_span = locate_start_span(self.less)
		return self.less:si(start_span + index)
	end
	
	self.diff = function (self, index)
		local start_span = locate_start_span(self.less)
		return self.less:diff(start_span + index)
	end
	
	self.push_back = function (self, text)
		if string.len(text) > 0 then
			self.stat:tick()
		end
		return self.less:push_back(text)
	end
	
	self.pop_back = function (self)
		return self.less:pop_back()
	end

	self.locate = function (self)
		local start_span = locate_start_span(self.less)
		return self.less:locate() - start_span
	end

	self.limit = function (self, index)
		local start_span = locate_start_span(self.less)
		return ucs2.len(self.less:se(start_span + index))
	end
	
	self.update = function(self)
		local ret = {}
		local i = 1
		for i = 1, self.span_count do
			local item = {
				exem   = w2u(self:se(i)),
				exem2  = w2u(self:se2(i)),
				exem3  = w2u(self:se3(i)),
				input  = w2u(self:si(i)),
				diff   = w2u(self:diff(i)),
				limit  = self:limit(i),
				active = false,
			}
			
			if self:locate() == i then
				item.active = true
			end
			ret[string.format("span%d", i)] = item
		end
		
		return json.encode(ret)
	end
	
	return self
end

-----------------------------------------------------------------------
return {new_page=new_page}
